function test_suite = testIszero %#ok<STOUT>
initTestSuite;

function testEmpty %#ok<*DEFNU>
x = polysym.empty;
assertEqual(iszero(x),logical.empty)

function testDefault
x = polysym;
assertTrue(iszero(x));

function testNumericZero
x = polysym(0);
assertTrue(iszero(x));

function testCharZeroNoPadding
x = polysym('0');
assertTrue(iszero(x));

function testCharZeroWithLeadingBlank
x = polysym(' 0');
assertTrue(iszero(x));

function testCharZeroWithTrailingBlank
x = polysym('0 ');
assertTrue(iszero(x));

function testCharZeroWithLeadingTab
x = polysym(sprintf('\t 0'));
assertTrue(iszero(x));

function testCharZeroWithTrailingTab
x = polysym(sprintf('0\t'));
assertTrue(iszero(x));

function testCharZeroWithDecimal
x = polysym('0.00');
assertTrue(iszero(x));
